CREATE OR REPLACE VIEW {schema}.vw_receivers AS 
SELECT dp.otn_array, dp.station_no, dp.consecutive_deploy_no, dp.rcv_model_no, dp.rcv_serial_no, 
dp.deploy_date, dp.dep_lat, dp.dep_long, dp.bottom_depth, dp.receiver_depth, 
rc.recover_date_time, rc.recover_lat, rc.recover_long, rc.recover_ind, rc.data_download_ind, 
st_setsrid(st_makepoint(dp.dep_long, dp.dep_lat), 4326) AS gis_point
FROM {schema}.rcvr_meta_deploy dp LEFT JOIN {schema}.rcvr_meta_recover rc 
ON dp.otn_array::text = rc.otn_array::text AND dp.station_no::text = rc.station_no::text AND 
dp.consecutive_deploy_no = rc.consecutive_deploy_no AND 
rc.recover_date_time IS NOT NULL AND upper(rc.recover_ind::text) = 'Y'::text;
