CREATE OR REPLACE VIEW {schema}.vw_download AS 
SELECT dw.otn_array, dw.station_no, dw.consecutive_deploy_no, dw.otn_mission_id, 
dw.rcv_model_no, dw.rcv_serial_no, dw.download_date_time AS date, dw.download_status, 
dp.dep_lat AS latitude, dp.dep_long AS longitude, 
dw.number_of_detections, dw.total_pulses_69kz, dw.total_pulses_other, dw.total_syncs_69kz, 
dw.total_syncs_other, dw.voltage_at_download, dw.tilt_at_download, dw.time_drift,
dw.resync_date_time AS resync_date, dw.memory_erased_ind, 
dp.gis_point AS the_geom, dw.file_name, dw.comments
FROM {schema}.rcvr_meta_download dw LEFT JOIN {schema}.vw_receivers dp 
ON dw.otn_array::text = dp.otn_array::text AND dw.station_no::text = dp.station_no::text AND
dw.rcv_model_no::text = dp.rcv_model_no::text AND dw.rcv_serial_no::text = dp.rcv_serial_no::text AND
dw.consecutive_deploy_no = dp.consecutive_deploy_no;
