CREATE OR REPLACE VIEW {schema}.vw_detection_summary AS 
SELECT date_part('year'::text, c_detections.date::text::date) AS year, 
(c_detections.code_space::text || '-'::text) || c_detections.id::text AS transmitter_name, count(*) AS detection_count
FROM {schema}.c_detections
WHERE NOT (c_detections.id::text IN 
    ( SELECT split_part(obis_detailcache.relatedcatalogitem::text, '-'::text, 2) AS split_part
      FROM {schema}.obis_detailcache
      WHERE obis_detailcache.basisofrecord::text = 'SENTINEL TAG'::text))
GROUP BY date_part('year'::text, c_detections.date::text::date), c_detections.code_space, c_detections.id;
