CREATE TABLE {schema}.stations
(
  station_name character varying NOT NULL,
  otn_array character varying,
  station_no character varying,
  notes character varying,
  locality character varying,
  CONSTRAINT stations_pkey PRIMARY KEY (station_name),
  CONSTRAINT stations_station_no_key UNIQUE (station_no)
)
WITH (
  OIDS=FALSE
);

CREATE SEQUENCE {schema}.seq_station START 1;

CREATE TABLE {schema}.station_history
(
  id integer NOT NULL,
  station_name character varying,
  intended_lat double precision,
  intended_long double precision,
  depth_m double precision,
  date character varying,
  otn_mission_id character varying,
  notes character varying,
  next_proposal_date character varying,
  proposal_number text,
  CONSTRAINT station_history_pkey PRIMARY KEY (id),
  CONSTRAINT station_history_station_name_fkey FOREIGN KEY (station_name)
      REFERENCES schema.stations (station_name) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);