CREATE TABLE {schema}.obis_moorings
(
  resource_id integer,
  datelastmodified character varying,
  recordlastcached character varying,
  basisofrecord character varying,
  institutioncode character varying,
  collectioncode character varying,
  catalognumber character varying(255),
  starttimecollected timestamp without time zone,
  endtimecollected timestamp without time zone,
  latitude double precision,
  longitude double precision,
  coordinateprecision double precision,
  slatitude double precision,
  elatitude double precision,
  slongitude double precision,
  elongitude double precision,
  seprecision double precision,
  minimumdepth double precision,
  maximumdepth double precision,
  sourceofrecord text,
  recordurl character varying,
  csquare text,
  depth double precision,
  depthprecision double precision,
  locality text,
  ocean character varying,
  country character varying,
  state character varying,
  county character varying,
  collectornumber character varying,
  fieldnumber character varying(255),
  timezone character varying,
  temperature double precision,
  relationshiptype character varying,
  relatedcatalogitem character varying(255),
  the_geom geometry,
  notes text,
  CONSTRAINT unq_moor UNIQUE (institutioncode, collectioncode, catalognumber)
)
WITH (
  OIDS=FALSE
);