CREATE TABLE {schema}.c_rcvr_deploy
(
  otn_array character varying,
  station_no character varying,
  consecutive_deploy_no character varying,
  intend_lat character varying,
  intend_long character varying,
  otn_mission_id character varying,
  deploy_date character varying,
  dep_lat character varying,
  dep_long character varying,
  bottom_depth character varying,
  riser_length character varying,
  receiver_depth character varying,
  check_complete_time character varying,
  status_in character varying,
  rcv_model_no character varying,
  rcv_serial_no character varying,
  sync_date_time character varying,
  memory_erased_ind character varying,
  rcv_battery_install_date character varying,
  rcv_battery_expected_life character varying,
  rcr_voltage_at_deploy character varying,
  rcv_tilt_after_deploy character varying,
  ar_model_no character varying,
  ar_serial_no character varying,
  ar_battery_install_date character varying,
  ar_battery_expected_life character varying,
  ar_voltage_at_deploy character varying,
  ar_tilt_after_deploy character varying,
  ar_interrogate_code character varying,
  ar_receive_frequency character varying,
  ar_reply_frequency character varying,
  ar_ping_rate character varying,
  ar_enable_code character varying,
  ar_release_code character varying,
  ar_disable_code character varying,
  ar_tilt_code character varying,
  deployed_by character varying,
  comments character varying,
  CONSTRAINT c_rcvr_deploy_otn_array_key UNIQUE (otn_array, station_no, consecutive_deploy_no)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE {schema}.c_rcvr_recovery
(
  otn_array character varying,
  station_no character varying,
  consecutive_deploy_no character varying,
  otn_mission_id character varying,
  ar_confirm character varying,
  data_download_ind character varying,
  recover_ind character varying,
  recover_date_time character varying,
  recover_lat character varying,
  recover_long character varying,
  comments character varying,
  CONSTRAINT c_rcvr_recovery_otn_array_key UNIQUE (otn_array, station_no, consecutive_deploy_no, otn_mission_id)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE {schema}.c_rcvr_download
(
  otn_array character varying,
  station_no character varying,
  consecutive_deploy_no character varying,
  otn_mission_id character varying,
  download_date_time character varying,
  rcv_model_no character varying,
  rcv_serial_no character varying,
  download_status character varying,
  number_of_detections character varying,
  total_pulses_69kz character varying,
  total_pulses_other character varying,
  total_syncs_69kz character varying,
  total_syncs_other character varying,
  voltage_at_download character varying,
  tilt_at_download character varying,
  time_drift character varying,
  resync_date_time character varying,
  memory_erased_ind character varying,
  file_name character varying,
  comments character varying
)
WITH (
  OIDS=FALSE
);