CREATE TABLE {schema}.rcvr_meta_deploy
(
  deploy_key integer NOT NULL,
  otn_array character varying,
  station_no character varying,
  consecutive_deploy_no integer,
  intend_lat double precision,
  intend_long double precision,
  otn_mission_id character varying,
  deploy_date timestamp without time zone,
  dep_lat double precision,
  dep_long double precision,
  bottom_depth numeric,
  riser_length numeric,
  receiver_depth numeric,
  check_complete_time time without time zone,
  status_in character varying,
  rcv_model_no character varying,
  rcv_serial_no character varying,
  sync_date_time timestamp without time zone,
  memory_erased_ind character varying,
  rcv_battery_install_date timestamp without time zone,
  rcv_battery_expected_life character varying,
  rcr_voltage_at_deploy numeric,
  rcv_tilt_after_deploy numeric,
  ar_model_no character varying,
  ar_serial_no character varying,
  ar_battery_install_date timestamp without time zone,
  ar_battery_expected_life character varying,
  ar_voltage_at_deploy numeric,
  ar_tilt_after_deploy numeric,
  ar_receive_frequency double precision,
  ar_reply_frequency double precision,
  ar_ping_rate numeric,
  ar_enable_code character varying,
  ar_release_code character varying,
  ar_disable_code character varying,
  ar_tilt_code character varying,
  deployed_by character varying,
  comments character varying,
  CONSTRAINT rcvr_meta_deploy_pkey PRIMARY KEY (deploy_key),
  CONSTRAINT fkey_dep_missid FOREIGN KEY (otn_mission_id)
      REFERENCES nsp.mission_reports (otn_mission_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fkey_dep_stn FOREIGN KEY (station_no)
      REFERENCES nsp.stations (station_no) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT rcvr_meta_deploy_otn_array_key UNIQUE (otn_array, station_no, consecutive_deploy_no)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE {schema}.rcvr_meta_recover
(
  recover_key integer NOT NULL,
  otn_array character varying,
  station_no character varying,
  consecutive_deploy_no integer,
  otn_mission_id character varying,
  ar_confirm character varying,
  data_download_ind character varying,
  recover_ind character varying,
  recover_date_time timestamp without time zone,
  recover_lat double precision,
  recover_long double precision,
  comments character varying,
  CONSTRAINT rcvr_meta_recover_pkey PRIMARY KEY (recover_key)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE {schema}.rcvr_meta_download
(
  download_key integer NOT NULL,
  otn_array character varying,
  station_no character varying,
  consecutive_deploy_no integer,
  otn_mission_id character varying,
  download_date_time timestamp without time zone,
  rcv_model_no character varying,
  rcv_serial_no character varying,
  download_status character varying,
  number_of_detections integer,
  total_pulses_69kz integer,
  total_pulses_other integer,
  total_syncs_69kz integer,
  total_syncs_other integer,
  voltage_at_download numeric,
  tilt_at_download integer,
  time_drift character varying,
  resync_date_time timestamp without time zone,
  memory_erased_ind character varying,
  file_name character varying,
  comments character varying,
  CONSTRAINT rcvr_meta_download_pkey PRIMARY KEY (download_key)
)
WITH (
  OIDS=FALSE
);